/**************************************************************************
 *
 * Copyright 2010, 2011 BMW Car IT GmbH
 * Copyright (C) 2011 DENSO CORPORATION and Robert Bosch Car Multimedia Gmbh
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include "WLContext.h"
#include "WLEGLSurface.h"
#include "WLEyes.h"
#include "WLEyesRenderer.h"
#include "ilm_control.h"
int gRunLoop = 0;
int gNeedRedraw = 0;
int gPointerX = 0;
int gPointerY = 0;


static void SigFunc(int)
{
    printf("Caught signal\n");
    gRunLoop = 0;
}

int main(int argc, char **argv)
{
    WLContext* wlContext;
    WLEGLSurface* eglSurface;
    WLEyes* eyes;
    t_ilm_layer   layerId   = 2000;
    t_ilm_surface surfaceId = 6100;
    t_ilm_string *pSeatArray;
    ilmErrorTypes lm_error = ILM_FAILED;
    t_ilm_uint numSeats = 0;
    t_ilm_string *pAccpSeats = NULL;
    ilmInputDevice bitmask = 0;
    pSeatArray = (t_ilm_string*)malloc(2 * sizeof(t_ilm_string));
    pSeatArray[0] = strdup("seat1");
    pSeatArray[1] = strdup("seat0");

    argc = argc; // avoid warning
    argv = argv;

    // signal handling
    signal(SIGINT,SigFunc);

    ilm_init();

    wlContext = new WLContext();
    wlContext->InitWLContext(&PointerListener, &KeyboardListener, &TouchListener);

    eglSurface = new WLEGLSurface(wlContext);
    eglSurface->CreateSurface(400, 240);
    eglSurface->CreateIlmSurface(&layerId, &surfaceId, 400, 240);
    lm_error = ilm_setInputAcceptanceOn(surfaceId, 2, pSeatArray);
    if (ILM_SUCCESS != lm_error)
    {
        printf("Failed to set input acceptance for surface:%x\n", lm_error);
    }



    lm_error = ilm_getInputAcceptanceOn(surfaceId, &numSeats, &pAccpSeats);
    if (ILM_SUCCESS != lm_error)
    {
        printf("Failed ilm_getInputAcceptanceOn\n");
    }
    for (unsigned int count = 0; count < numSeats; count++)
    {
        printf("surface : %x, accepts input form seat: %s\n", surfaceId, pAccpSeats[count]);
    }


    numSeats = 0;
    pAccpSeats = NULL;
    lm_error = ilm_getInputDevices(ILM_INPUT_DEVICE_TOUCH, &numSeats, &pAccpSeats);
    if (ILM_SUCCESS != lm_error)
    {
        printf("Failed ilm_getInputDevices\n");
    }
    for (unsigned int count = 0; count < numSeats; count++)
    {
        printf("ILM_INPUT_DEVICE_TOUCH : is supported by seat: %s\n", pAccpSeats[count]);
    }



    lm_error = ilm_getInputDeviceCapabilities(pSeatArray[1], &bitmask);
    if (ILM_SUCCESS != lm_error)
    {
        printf("Failed ilm_getInputDeviceCapabilities\n");
    }
    printf("%s seat supports :%x devices", "seat0", bitmask);
    bitmask = 0;
    lm_error = ilm_getInputDeviceCapabilities(pSeatArray[0], &bitmask);
    if (ILM_SUCCESS != lm_error)
    {
        printf("Failed ilm_getInputDeviceCapabilities\n");
    }
    printf("%s seat supports :%x devices", "seat1", bitmask);

    eyes = new WLEyes(400, 240);

    // initialize eyes renderer
    if (!InitRenderer()){
        fprintf(stderr, "Failed to init renderer\n");
        return -1;
    }

    // draw eyes once
    DrawEyes(eglSurface, eyes);

    // wait for input event
    gRunLoop = 1;
    gNeedRedraw = 0;
    while (gRunLoop){
        WaitForEvent(wlContext->GetWLDisplay());
        if (gNeedRedraw && gRunLoop){
            DrawEyes(eglSurface, eyes);
            gNeedRedraw = 0;
        }
        usleep(50);
    }

    TerminateRenderer();
    ilm_layerRemoveSurface(layerId, surfaceId);
    ilm_UpdateInputEventAcceptanceOn(surfaceId,
                                    ILM_INPUT_DEVICE_POINTER | ILM_INPUT_DEVICE_TOUCH,
                                    ILM_FALSE);
    ilm_commitChanges();
    eglSurface->DestroyIlmSurface();
    ilm_commitChanges();

    ilm_destroy();
    delete eyes;
    delete eglSurface;
    delete wlContext;

    return 0;
}
